<?php
include 'includes/header.php';
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

// Handle adding car to comparison
if (isset($_GET['add'])) {
    if (!isset($_SESSION['compare'])) {
        $_SESSION['compare'] = [];
    }
    if (!in_array($_GET['add'], $_SESSION['compare']) && count($_SESSION['compare']) < 3) {
        $_SESSION['compare'][] = $_GET['add'];
    }
    redirect('compare.php');
}

// Handle removing car from comparison
if (isset($_GET['remove'])) {
    if (isset($_SESSION['compare'])) {
        $key = array_search($_GET['remove'], $_SESSION['compare']);
        if ($key !== false) {
            unset($_SESSION['compare'][$key]);
            $_SESSION['compare'] = array_values($_SESSION['compare']); // Reindex array
        }
    }
    redirect('compare.php');
}

// Get cars for comparison
$compare_cars = [];
if (isset($_SESSION['compare']) && !empty($_SESSION['compare'])) {
    $placeholders = str_repeat('?,', count($_SESSION['compare']) - 1) . '?';
    $query = "SELECT c.*, b.name as brand_name, m.name as model_name 
              FROM cars c 
              LEFT JOIN brands b ON c.brand_id = b.id 
              LEFT JOIN models m ON c.model_id = m.id 
              WHERE c.id IN ($placeholders)";
    $stmt = $db->prepare($query);
    $stmt->execute($_SESSION['compare']);
    $compare_cars = $stmt->fetchAll();
}
?>

<div class="container py-4">
    <h2 class="mb-4">Compare Cars</h2>

    <?php if (empty($compare_cars)): ?>
        <div class="alert alert-info">
            Select cars to compare from our inventory. You can compare up to 3 cars at once.
            <br>
            <a href="cars.php" class="btn btn-primary mt-3">Browse Cars</a>
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Features</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <th class="text-center">
                                <img src="<?php echo htmlspecialchars($car['main_image']); ?>" 
                                     alt="<?php echo htmlspecialchars($car['title']); ?>"
                                     style="width: 200px; height: 150px; object-fit: cover;">
                                <h5 class="mt-2"><?php echo htmlspecialchars($car['title']); ?></h5>
                                <a href="compare.php?remove=<?php echo $car['id']; ?>" 
                                   class="btn btn-sm btn-danger">Remove</a>
                            </th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <th>Price</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center">$<?php echo number_format($car['price']); ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <th>Brand</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center"><?php echo htmlspecialchars($car['brand_name']); ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <th>Model</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center"><?php echo htmlspecialchars($car['model_name']); ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <th>Year</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center"><?php echo $car['year']; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <th>Mileage</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center"><?php echo number_format($car['mileage']); ?> km</td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <th>Fuel Type</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center"><?php echo $car['fuel_type']; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <th>Transmission</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center"><?php echo $car['transmission']; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <th>Condition</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center"><?php echo $car['condition_type']; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <th>Actions</th>
                        <?php foreach ($compare_cars as $car): ?>
                            <td class="text-center">
                                <a href="car-details.php?id=<?php echo $car['id']; ?>" 
                                   class="btn btn-primary btn-sm">View Details</a>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                </tbody>
            </table>
        </div>

        <?php if (count($compare_cars) < 3): ?>
            <div class="mt-3">
                <a href="cars.php" class="btn btn-primary">Add Another Car</a>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<style>
.table th {
    background-color: #f8f9fa;
}
.table td {
    vertical-align: middle;
}
</style>

<?php include 'includes/footer.php'; ?> 